#ifndef __INC_AFFECT_H
#define __INC_AFFECT_H

class CAffect
{
	public:
		DWORD	dwType;
		BYTE    bApplyOn;
		long    lApplyValue;
		DWORD   dwFlag;
		long	lDuration;
		long	lSPCost;

		static CAffect* Acquire();
		static void Release(CAffect* p);
};

enum EAffectTypes
{
	AFFECT_NONE,

	AFFECT_MOV_SPEED		= 200,
	AFFECT_ATT_SPEED,
	AFFECT_ATT_GRADE,
	AFFECT_INVISIBILITY,
	AFFECT_STR,
	AFFECT_DEX,			// 205
	AFFECT_CON,
	AFFECT_INT,
	AFFECT_FISH_MIND_PILL,

	AFFECT_POISON,
	AFFECT_STUN,		// 210
	AFFECT_SLOW,
	AFFECT_DUNGEON_READY,
	AFFECT_DUNGEON_UNIQUE,

	AFFECT_BUILDING,
	AFFECT_REVIVE_INVISIBLE,	// 215
	AFFECT_FIRE,
	AFFECT_CAST_SPEED,
	AFFECT_HP_RECOVER_CONTINUE,
	AFFECT_SP_RECOVER_CONTINUE,

	AFFECT_POLYMORPH,		// 220
	AFFECT_MOUNT,

	AFFECT_WAR_FLAG,		// 222

	AFFECT_BLOCK_CHAT,		// 223
	AFFECT_CHINA_FIREWORK,

	AFFECT_BOW_DISTANCE,	// 225
	AFFECT_DEF_GRADE,		// 226
	AFFECT_PK_PROTECT, // 227

	AFFECT_PREMIUM_START	= 500,
	AFFECT_EXP_BONUS		= 500,
	AFFECT_ITEM_BONUS		= 501,
	AFFECT_SAFEBOX		= 502,  // PREMIUM_SAFEBOX,
	AFFECT_AUTOLOOT		= 503,	// PREMIUM_AUTOLOOT,
	AFFECT_FISH_MIND		= 504,	// PREMIUM_FISH_MIND,
	AFFECT_MARRIAGE_FAST	= 505,
	AFFECT_GOLD_BONUS		= 506,
	AFFECT_PREMIUM_END		= 509,

	AFFECT_MALL			= 510,
	AFFECT_NO_DEATH_PENALTY	= 511,
	AFFECT_SKILL_BOOK_BONUS	= 512,
	AFFECT_SKILL_NO_BOOK_DELAY	= 513,

	AFFECT_HAIR	= 514,
	AFFECT_COLLECT = 515,
	AFFECT_EXP_BONUS_EURO_FREE = 516,
	AFFECT_EXP_BONUS_EURO_FREE_UNDER_15 = 517,
	AFFECT_UNIQUE_ABILITY = 518,

	AFFECT_CUBE_1,
	AFFECT_CUBE_2,
	AFFECT_CUBE_3,
	AFFECT_CUBE_4,
	AFFECT_CUBE_5,
	AFFECT_CUBE_6,
	AFFECT_CUBE_7,
	AFFECT_CUBE_8,
	AFFECT_CUBE_9,
	AFFECT_CUBE_10,
	AFFECT_CUBE_11,
	AFFECT_CUBE_12,

	AFFECT_BLEND,

	AFFECT_HORSE_NAME,
	AFFECT_MOUNT_BONUS,

	AFFECT_AUTO_HP_RECOVERY = 534,
	AFFECT_AUTO_SP_RECOVERY = 535,

	AFFECT_DRAGON_SOUL_QUALIFIED = 540,
	AFFECT_DRAGON_SOUL_DECK_0 = 541,
	AFFECT_DRAGON_SOUL_DECK_1 = 542,

#ifdef ENABLE_ANTIEXP_RING
	AFFECT_ANTIEXP = 543,
#endif
	AFFECT_RESEARCHER_ELIXIR = 545,


	AFFECT_RAMADAN_ABILITY = 300,
	AFFECT_RAMADAN_RING	   = 301,

	AFFECT_NOG_ABILITY = 302,
	AFFECT_HOLLY_STONE_POWER = 303,

#ifdef ENABLE_BIOLOG_SYSTEM
	AFF_BIO_1,
	AFF_BIO_2,
	AFF_BIO_3,
	AFF_BIO_4,
	AFF_BIO_5,
	AFF_BIO_6,
	AFF_BIO_7,
	AFF_BIO_8,
	AFF_BIO_9,
	AFF_BIO_10,
	AFF_BIO_11,
#endif

#ifdef ENABLE_PERMANENT_AFFECT
	AFFECT_CRITICALA = 600,
	AFFECT_PATRUNDERE = 601,
	AFFECT_ZEU_DRAGON1 = 602,
	AFFECT_ZEU_DRAGON2 = 603,
	AFFECT_ZEU_DRAGON3 = 604,
	AFFECT_ZEU_DRAGON4 = 605,
#endif

	AFFECT_QUEST_START_IDX = 1000
};

enum EAffectBits
{
	AFF_NONE,

	AFF_YMIR,
	AFF_INVISIBILITY,
	AFF_SPAWN,

	AFF_POISON,
	AFF_SLOW,
	AFF_STUN,

	AFF_DUNGEON_READY,
	AFF_DUNGEON_UNIQUE,

	AFF_BUILDING_CONSTRUCTION_SMALL,
	AFF_BUILDING_CONSTRUCTION_LARGE,
	AFF_BUILDING_UPGRADE,

	AFF_MOV_SPEED_POTION,
	AFF_ATT_SPEED_POTION,

	AFF_FISH_MIND,

	AFF_JEONGWIHON,
	AFF_GEOMGYEONG,
	AFF_CHEONGEUN,
	AFF_GYEONGGONG,
	AFF_EUNHYUNG,
	AFF_GWIGUM,
	AFF_TERROR,
	AFF_JUMAGAP,
	AFF_HOSIN,
	AFF_BOHO,
	AFF_KWAESOK,
	AFF_MANASHIELD,
	AFF_MUYEONG,
	AFF_REVIVE_INVISIBLE,
	AFF_FIRE,
	AFF_GICHEON,
	AFF_JEUNGRYEOK,
	AFF_TANHWAN_DASH,
	AFF_PABEOP,
	AFF_CHEONGEUN_WITH_FALL,
	AFF_POLYMORPH,
	AFF_WAR_FLAG1,
	AFF_WAR_FLAG2,
	AFF_WAR_FLAG3,

	AFF_CHINA_FIREWORK,
	AFF_HAIR,
	AFF_GERMANY,
	AFF_RAMADAN_RING,

	AFF_BITS_MAX
};

extern void SendAffectAddPacket(LPDESC d, CAffect * pkAff);

// AFFECT_DURATION_BUG_FIX
enum AffectVariable
{
	INFINITE_AFFECT_DURATION = 60 * 365 * 24 * 60 * 60
};
// END_AFFECT_DURATION_BUG_FIX

#endif
